//	CEntryArray.h

#ifndef _H_CEntryArray
#define _H_CEntryArray

class	CEntry;
class	CEntryArray;

#define	kDefaultEntryArraySize	20L

typedef CEntry	**CEntryA;
typedef struct	{
	long		num_items;		//	base 1
	long		array_size;		//	base 1
	CEntryA		entryA;
} TA_LIST;

#define	TA_Index_START	0L
#define	TA_Index_END	-1L
#define	TA_Index_NONE	-131072L

/************************************************/

enum {
	TA_Iterate_NONE, 

	TA_Iterate_DRAW, 
	TA_Iterate_INVALID, 
	TA_Iterate_VALID, 
	TA_Iterate_COUNT_RECURSE, 
	TA_Iterate_COUNT_RECURSE_DELETED, 
	TA_Iterate_DISPOSE, 
	TA_Iterate_DELETE, 
	TA_Iterate_FLUSH_MEM_DISK, 
	TA_Iterate_UNDELETE, 
	TA_Iterate_DUPLICATE, 
	TA_Iterate_SELECT, 
	TA_Iterate_REORDER, 
	TA_Iterate_ADD_TO_DRAG, 
	TA_Iterate_SET_PENDING_COPY, 
	TA_Iterate_UNMOUNT_DRIVE, 
	TA_Iterate_DO_COMMAND, 
	TA_Iterate_GET_DISKS_OF_SELECTION, 
	TA_Iterate_SET_SHOW_DELETED, 
	TA_Iterate_RESTORE_SHOW_DELETED, 
	TA_Iterate_TOGGLE_SHOW_DELETED, 
	
	TA_Iterate_NUMTYPES
};
typedef short TA_IterateType;

typedef struct {
	long		newIndex;
	CEntry	*recentEntry;
} TA_Iterate_REORDERData;

typedef struct {
	DragRef		dragRef;
	RgnHandle	dragRgn;
} TA_Iterate_ADD_TO_DRAG_Data;

typedef struct {
	Boolean		select;
	Boolean		draw;
} TA_Iterate_SELECTData;

typedef struct {
	FSSpec		*folderSpecP;
} TA_Iterate_SET_PENDING_COPYData;

typedef union {
	TA_Iterate_SELECTData			select;
	TA_Iterate_REORDERData			reorder;
	TA_Iterate_ADD_TO_DRAG_Data		drag;
	TA_Iterate_SET_PENDING_COPYData	copy;
	long							commandL;
	Boolean							flushB;
	CEntryArray						*selectionP;
} TA_IterateData;

/************************************/
CEntryArray		*GetNewEntryArray(void);

#define		CE_FOR_EACH(_CE, _INDEX, _ENTRYP, _ERR)	\
	for (_INDEX = 0; !(_ERR) && _INDEX < _CE->i_array.num_items; _INDEX++) {	\
		_ENTRYP = _CE->i_array.entryA[_INDEX];

#define		CE_FOR_EACH_REVERSE(_CE, _INDEX, _ENTRYP, _ERR)	\
	for (_INDEX = _CE->i_array.num_items - 1; !(_ERR) && _INDEX >= 0; _INDEX--) {	\
		_ENTRYP = _CE->i_array.entryA[_INDEX];

#define		CE_END_EACH()	} 	if (err == IC_Err_BREAK_FROM_LOOP) err = noErr;


typedef OSErr 	(*EntryA_CompareFunc)(
	void *refconPV, CEntryArray *thiz, 
	const void *a, const void *b, int *resultS);

class	CEntryArray {

	public:	void				IEntryArray(void);
		
	virtual	void				Dispose(void);

	virtual	CEntryArray			*Duplicate(void);
	
	virtual	OSErr				Add(CEntry *pane);
	virtual	long				IndexOf(CEntry *pane);
	virtual	Boolean				Member(CEntry *pane);
	virtual	void				Remove(CEntry *pane);
	virtual	void				RemoveAll(void);

	virtual	long				Count(void);
	virtual	CEntry				*GetIndEntry(long index);
	
	virtual	OSErr				IterateReverse(TA_IterateType taType, void *cbData);
	virtual	OSErr				Iterate(TA_IterateType taType, void *cbData);
		
	OSErr		Sort(EntryA_CompareFunc SortFuncCB, void *refconPV0);

	/*******************************************/

	TA_LIST					i_array;
};

#endif